package com.instabug.library.sessionV3.cache

import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract.SessionExperimentEntry.COLUMN_SESSION_SERIAL
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract.SessionExperimentEntry.TABLE_NAME
import com.instabug.library.internal.storage.cache.dbv2.asArgs
import com.instabug.library.internal.storage.cache.dbv2.joinToArgs
import com.instabug.library.internal.storage.cache.dbv2.kQuery
import com.instabug.library.model.v3Session.IBGSessionExperiments
import com.instabug.library.model.v3Session.asContentValues
import com.instabug.library.model.v3Session.asSessionExperimentsMap
import com.instabug.library.sessionV3.di.IBGSessionServiceLocator
import com.instabug.library.util.extenstions.runOrLogError

interface SessionExperimentsCacheManager {
    fun queryExperiments(sessionsSerials: List<Long>): Map<Long, IBGSessionExperiments>
    fun insert( experiments: IBGSessionExperiments)
}

object SessionExperimentsCacheManagerImpl : SessionExperimentsCacheManager {
    private val database by lazy { IBGSessionServiceLocator.database }
    override fun queryExperiments(sessionsSerials: List<Long>): Map<Long, IBGSessionExperiments> {
        return database.runOrLogError(errorMessage = "something went wrong while querying experiments") {
            kQuery(
                TABLE_NAME,
                whereClause = whereSessionSerialIn(sessionsSerials)
            )?.asSessionExperimentsMap
        }.getOrNull().orEmpty()
    }

    private fun whereSessionSerialIn(sessionsSerials: List<Long>) =
        ("$COLUMN_SESSION_SERIAL IN ${sessionsSerials.joinToArgs()}"
                to sessionsSerials.map { it.toString() }.asArgs())

    override fun insert(experiments: IBGSessionExperiments) {
        database.runOrLogError(errorMessage = "something went wrong while inserting experiments") {
            insertWithOnConflictReplace(TABLE_NAME, null, experiments.asContentValues)
        }
    }

}