package com.instabug.library.networkv2.service.userattributes;

import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributeCacheManager;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributesDbHelper;
import com.instabug.library.model.UserAttribute;

import java.util.List;

class AttributesLocalDataSource {

    /**
     * Adds a bulk of entities to the database and updates the existing once
     *
     * @param entities the list of user attributes to be saved or updated
     */
    public void saveOrUpdateBatch(List<UserAttribute> entities) {
        UserAttributesDbHelper.insertBulk(entities);

    }

    /**
     * Clears all user attributes from database
     */
    public void deleteAll() {
        UserAttributeCacheManager.deleteAll(UserAttribute.Type.BACKEND);
    }
}
