package com.instabug.library.networkv2.connection;

import androidx.annotation.NonNull;

import com.instabug.library.Constants;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;

/**
 * An implementation class to manage the connection of the normal requests with files to upload.
 */
public class FileDownloadConnectionManager extends NormalConnectionManager {

    @Override
    public RequestResponse handleResponse(HttpURLConnection connection,
                                          @NonNull Request request) throws IOException {
        RequestResponse requestResponse = new RequestResponse();
        int responseCode = connection.getResponseCode();
        requestResponse.setResponseCode(responseCode);
        requestResponse.setHeaders(getHeaderFields(connection));
        File downloadedFile = request.getDownloadedFile();
        if (downloadedFile != null) {
            copyStream(connection, downloadedFile);
        } else {
            requestResponse.setResponseBody(null);
        }
        requestResponse.setResponseBody(downloadedFile);
        connection.disconnect();
        return requestResponse;
    }

    private void copyStream(HttpURLConnection connection, File downloadedFile) throws IOException {
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        int singleByte;
        try {
            inputStream = connection.getInputStream();
            outputStream = new FileOutputStream(downloadedFile);
            while ((singleByte = inputStream.read()) != -1) {
                outputStream.write(singleByte);
            }
        } finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                } catch (IOException e) {
                    InstabugSDKLogger.e(Constants.LOG_TAG, "Error while closing output stream");
                }
                try {
                    outputStream.close();
                } catch (IOException e) {
                    InstabugSDKLogger.e(Constants.LOG_TAG, "Error while closing output stream");
                }
            }
            if(inputStream != null) {
                inputStream.close();
            }

        }
    }
}
