package com.instabug.library.networkDiagnostics.model

import androidx.annotation.VisibleForTesting
import org.json.JSONException
import org.json.JSONObject

@VisibleForTesting
const val KEY_TODAY = "today"
@VisibleForTesting
const val KEY_LAST_ACTIVE_DAY = "last_active_day"

data class NetworkDiagnosticsWrapper(
    val today: NetworkDiagnostics,
    val lastActiveDay: NetworkDiagnostics
)

fun NetworkDiagnosticsWrapper.toJson(): String =
    JSONObject().apply {
        put(KEY_TODAY, JSONObject(today.toJson()))
        put(KEY_LAST_ACTIVE_DAY, JSONObject(lastActiveDay.toJson()))
    }.toString()


fun String.toNetworkDiagnosticsWrapper(): NetworkDiagnosticsWrapper =
    try {
        with(JSONObject(this)) {
            NetworkDiagnosticsWrapper(
                today = getJSONObject(KEY_TODAY).toString().toNetworkDiagnostics(),
                lastActiveDay = getJSONObject(KEY_LAST_ACTIVE_DAY).toString().toNetworkDiagnostics()
            )
        }
    } catch (exception: JSONException) {
        NetworkDiagnosticsWrapper(NetworkDiagnostics(), NetworkDiagnostics())
    }
