package com.instabug.library.model;

import java.io.Serializable;

import androidx.annotation.Nullable;

/**
 * Created by vezikon on 7/11/16.
 */
public abstract class BaseReport implements Serializable {
    @Nullable
    protected String id;
    @Nullable
    protected State state;
    private boolean hasVideo = false;
    private boolean isVideoEncoded = false;

    @Nullable
    public String getId() {
        return id;
    }

    public BaseReport setId(@Nullable String id) {
        this.id = id;
        return this;
    }

    /**
     * @return State of this chat if exist.
     */
    @Nullable
    public State getState() {
        return state;
    }

    public BaseReport setState(@Nullable State state) {
        this.state = state;
        return this;
    }

    public boolean hasVideo() {
        return hasVideo;
    }

    public BaseReport setHasVideo(boolean hasVideo) {
        this.hasVideo = hasVideo;
        return this;

    }

    public boolean isVideoEncoded() {
        return isVideoEncoded;
    }

    public BaseReport setVideoEncoded(boolean videoEncoded) {
        isVideoEncoded = videoEncoded;
        return this;

    }
}
