package com.instabug.library.internal.storage.cache.dbv2.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract
import com.instabug.library.internal.storage.cache.dbv2.IBGEncryptedDbVersions

class DBMigrationV12(override val db: SQLiteDatabase) : BaseDBMigrationImpl(db) {
    override val previous: BaseDbMigration by lazy { DBMigrationV11(db) }

    override val version: Int
        get() = IBGEncryptedDbVersions.DB_V12

    override fun execute() =
        runLogic { db.execSQL(IBGDbContract.SessionReplayMetadataEntry.CREATE_TABLE) }
}