package com.instabug.library.internal.filestore

import org.json.JSONArray
import org.json.JSONObject

interface DataAggregator<Out> {
    fun add(data: JSONObject)
    fun aggregate(): Out
}

class JSONArrayDataAggregator : DataAggregator<JSONArray> {

    private val result = JSONArray()

    override fun add(data: JSONObject) {
        result.put(data)
    }

    override fun aggregate(): JSONArray = result
}

/**
 * Aggregates incoming data to the last JSON object in the stream.
 * In case of files with only one JSON object as its content, this will retrieve all the file content.
 */
class JSONObjectAggregator : DataAggregator<JSONObject?> {
    private var jsonObject: JSONObject? = null
    override fun add(data: JSONObject) {
        jsonObject = data
    }

    override fun aggregate(): JSONObject? = jsonObject
}