package com.instabug.library.internal.dataretention.files.logs;

import com.instabug.library.internal.dataretention.core.Contract;
import com.instabug.library.internal.dataretention.files.FileDisposalPolicy;
import com.instabug.library.internal.dataretention.files.FileRule;
import com.instabug.library.internal.dataretention.files.FileScope;

import java.util.Arrays;
import java.util.Collection;

import androidx.annotation.NonNull;

public abstract class LogFileDisposalPolicy extends FileDisposalPolicy {

    public static class Factory extends FileDisposalPolicy.Factory {

        public FileDisposalPolicy create(@NonNull final String directoryPath,
                                         @NonNull final Contract contract,
                                         @NonNull final FileRule... exceptionRules) {
            return new LogFileDisposalPolicy() {

                @NonNull
                @Override
                public FileScope scope() {
                    return new LogFileScopeFactory().create(directoryPath);
                }

                @NonNull
                @Override
                public Collection<FileRule> exceptionRules() {
                    return Arrays.asList(exceptionRules);
                }

                @NonNull
                @Override
                public Contract retentionContract() {
                    return contract;
                }
            };
        }
    }
}
