package com.instabug.library.internal.dataretention;

import android.database.Cursor;

import com.instabug.library.Constants;
import com.instabug.library.internal.storage.cache.db.DatabaseManager;
import com.instabug.library.internal.storage.cache.db.SQLiteDatabaseWrapper;
import com.instabug.library.util.InstabugSDKLogger;

import java.util.ArrayList;
import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;

/**
 * A representation of a data scope in the database that holds the bare minimum info needed to access the
 * actual data records in the database
 *
 * @deprecated see {@link com.instabug.library.internal.dataretention.core.Scope}
 */
@Deprecated
public abstract class Scope {

    /**
     * @return the table name where data are stored
     */
    @NonNull
    public abstract String table();

    /**
     * @return all records in the table
     */
    @NonNull
    @WorkerThread
    public abstract List<Record> records();

    public static class Factory {

        public Scope create(final String tableName, final String idColumn, final String lastLoginColumn) {
            return new Scope() {
                @NonNull
                @Override
                public String table() {
                    return tableName;
                }

                @NonNull
                @Override
                @WorkerThread
                public List<Record> records() {
                    return queryAllRecords(tableName, idColumn, lastLoginColumn);
                }
            };
        }

        @NonNull
        private List<Record> queryAllRecords(String tableName, String idColumn, String lastLoginColumn) {
            SQLiteDatabaseWrapper db = DatabaseManager.getInstance().openDatabase();
            String[] columns = {idColumn, lastLoginColumn};
            List<Record> records = new ArrayList<>();
            Cursor cursor = null;
            try {
                cursor = db.query(tableName, columns, null, null, null, null, null);
                if (cursor != null && cursor.getCount() > 0) {
                    int idColumnIndex = cursor.getColumnIndex(idColumn);
                    int ageColumnIndex = cursor.getColumnIndex(lastLoginColumn);
                    while (cursor.moveToNext()) {
                        String id = cursor.getString(idColumnIndex);
                        long age = cursor.getLong(ageColumnIndex);
                        Field<String> identifierField = new Field<>(idColumn, id);
                        Field<Long> ageField = new Field<>(lastLoginColumn, age);
                        records.add(new Record(identifierField, ageField));
                    }
                }
            } catch (Exception e) {
                InstabugSDKLogger.e(Constants.LOG_TAG, "DB query failed: ", e);
            } finally {
                if (cursor != null) {
                    cursor.close();
                }
                db.close();
            }
            return records;
        }
    }
}
