package com.instabug.library.instacapture.utility

import android.app.Activity
import android.graphics.Rect
import android.view.View
import androidx.annotation.RestrictTo

/**
 * Return root view bounds in window if:
 * - Activity is visual.
 * - Top level window decor has been created.
 *
 * @return [Rect]
 *
 * @see View.getLocationInWindow
 * */
@RestrictTo(RestrictTo.Scope.LIBRARY_GROUP)
public fun Activity.rootViewBoundsInWindow(): Rect? = runCatching {
    window?.peekDecorView()
        ?.rootView
        ?.run {
            val location = IntArray(2)
            getLocationInWindow(location)
            val (left, top) = location

            Rect(
                left,
                top,
                left + width,
                top + height
            )
        }
}.getOrNull()
