package com.instabug.library.firstseen;

import static com.instabug.library.Instabug.getApplicationContext;

import android.content.Context;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;

import com.instabug.library.Constants;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugSDKLogger;

import org.json.JSONException;
import org.json.JSONObject;

public class FirstSeenRequestFetcher {


    @VisibleForTesting
    boolean isFirstSeenRequestFetched;

   @Nullable
   private static FirstSeenRequestFetcher instance;

    @VisibleForTesting
    public FirstSeenRequestFetcher() {
    }

    public static synchronized FirstSeenRequestFetcher getInstance() {
        if (instance == null) {
            instance = new FirstSeenRequestFetcher();
        }
        return instance;
    }

    public void fetchFirstSeenRequest(boolean forceReFetch) {
        try {
            Context context = getApplicationContext();
            if (context != null) {
                getCurrentAppVersionFirstSeen(context, forceReFetch);
            }
        } catch (Exception e) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "json exception while fetching first_seen request" + e.getMessage());
        }
    }

    /**
     * This is to get first_seen to be used for app version validations
     * For more info, check the story on Jira with ID: IBGSRV-6910
     *
     * @param context
     * @throws JSONException
     */
    public synchronized void getCurrentAppVersionFirstSeen(final Context context, boolean forceReFetch) throws JSONException {
        if (shouldFetchFirstSeen(context, forceReFetch)) {
            isFirstSeenRequestFetched = true;
            FirstSeenRequestService.getInstance().getCurrentAppVersionFirstSeen(context,
                    new Request.Callbacks<JSONObject, Throwable>() {
                        @Override
                        public void onSucceeded(@Nullable JSONObject response) {
                            if (response != null) {
                                if (response.has("first_seen")) {
                                    try {
                                        long firstSeen = response.getLong("first_seen");
                                        // backend returns -1 when the version has not been added to versions table
                                        if (firstSeen != -1) {
                                            // set first seen
                                            SettingsManager.getInstance().setFirstSeen(firstSeen);
                                            // set app version
                                            SettingsManager.getInstance().setLastAppVersion(DeviceStateProvider.getAppVersion(context));
                                        }

                                    } catch (Exception e) {
                                        InstabugSDKLogger.e(Constants.LOG_TAG, "Something went wrong while parsing first_seen response");
                                    }
                                } else {
                                    isFirstSeenRequestFetched = false;
                                    InstabugSDKLogger.v(Constants.LOG_TAG, "first_seen response doesn't has a key first_seen");
                                }
                            } else {
                                isFirstSeenRequestFetched = false;
                                InstabugSDKLogger.e(Constants.LOG_TAG, "first_seen response is null");
                            }
                        }

                        @Override
                        public void onFailed(Throwable error) {
                            isFirstSeenRequestFetched = false;
                            InstabugSDKLogger.e(Constants.LOG_TAG, "Fetching first seen response ");

                        }
                    });
        }
    }

    @VisibleForTesting
    public boolean shouldFetchFirstSeen(Context context, boolean force) {
        if (force)
            return true;

        if (isFirstSeenRequestFetched) {
            return false;
        }
        if (SettingsManager.getInstance().getLastAppVersion() == null
                || !DeviceStateProvider.getAppVersion(context).equals(SettingsManager.getInstance().getLastAppVersion())) {
            // reset app version to avoid not updating if the request failed
            SettingsManager.getInstance().setLastAppVersion(null);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public static void reset() {
        instance = null;
    }
}
