package com.instabug.library.experiments.di;

import androidx.annotation.Nullable;

import com.instabug.library.experiments.ExperimentsManager;
import com.instabug.library.experiments.ExperimentsManagerImpl;
import com.instabug.library.experiments.cache.ExperimentsDBManager;
import com.instabug.library.experiments.cache.ExperimentsDBManagerImpl;
import com.instabug.library.experiments.constants.Constants;
import com.instabug.library.internal.storage.cache.db.DatabaseManager;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.threading.PoolProvider;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class ServiceLocator {

    private static final Map<String, WeakReference<Object>> instances = new HashMap<String, WeakReference<Object>>();

    @Nullable
    private static Object getCreatedInstanceIfAny(String key) {
        if (instances.containsKey(key)) {
            return instances.get(key).get();
        }
        return null;
    }

    public synchronized static Executor getIOExecutor() {
        return PoolProvider.getInstance().getBackgroundExecutor();
    }

    public synchronized static ExperimentsManager getExperimentsManager() {
        String key = ExperimentsManager.class.getName();

        Object experimentsManager = getCreatedInstanceIfAny(key);
        if (experimentsManager == null) {
            experimentsManager = new ExperimentsManagerImpl();
            instances.put(key, new WeakReference<>(experimentsManager));
        }
        return (ExperimentsManager) experimentsManager;
    }

    public synchronized static ExperimentsDBManager getExperimentsDBManager() {
        String key = ExperimentsDBManager.class.getName();

        Object experimentsDBManager = getCreatedInstanceIfAny(key);
        if (experimentsDBManager == null) {
            experimentsDBManager = new ExperimentsDBManagerImpl();
            instances.put(key, new WeakReference<>(experimentsDBManager));
        }
        return (ExperimentsDBManager) experimentsDBManager;
    }

    public synchronized static DatabaseManager getDatabaseManager() {
        return DatabaseManager.getInstance();
    }

    public synchronized static void reset() {
        instances.clear();
    }

    public static int getExperimentsStoreLimit(){
        SettingsManager settingsManager = SettingsManager.getInstance();
        if (settingsManager != null) {
            return settingsManager.getExperimentsStoreLimit();
        }
        return Constants.EXPERIMENTS_STORE_LIMIT_FALLBACK;
    }
}
