package com.instabug.library.core.plugin

import com.instabug.library.sessionV3.providers.FeatureSessionDataController
import com.instabug.library.sessionV3.providers.FeatureSessionDataControllerHost
import com.instabug.library.sessionV3.providers.FeatureSessionLazyDataProvider
import com.instabug.library.sessionreplay.di.SessionReplayServiceLocator

interface PluginsExtractor {
    /**
     * extract sessions data controllers from plugin list
     * if any plugin implements {@link #FeatureSessionDataControllerHost}
     * @param plugins a list of plugins that may have a session data controller host
     * @return  list of FeatureSessionDataController to collect or delete session data
     *@see FeatureSessionDataControllerHost
     *@see FeatureSessionDataController
     * */
    fun extractSessionDataControllers(plugins: List<Plugin>): List<FeatureSessionDataController>

    fun extractSessionDataLazyProviders(plugins: List<Plugin>): List<FeatureSessionLazyDataProvider>
}

object PluginsExtractorImpl : PluginsExtractor {
    private val nonPluginControllerHosts: List<FeatureSessionDataControllerHost>
        get() = listOf(SessionReplayServiceLocator.sessionDataControllerHost)

    override fun extractSessionDataControllers(plugins: List<Plugin>) = plugins
        .filterIsInstance(FeatureSessionDataControllerHost::class.java)
        .map { host -> host.sessionDataController } +
            nonPluginControllerHosts.map { host -> host.sessionDataController }

    override fun extractSessionDataLazyProviders(
        plugins: List<Plugin>
    ): List<FeatureSessionLazyDataProvider> =
        plugins.filterIsInstance<FeatureSessionLazyDataProvider>()
}