/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.res.Configuration;
import android.hardware.display.DisplayManager;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.os.ConfigurationCompat;
import com.instabug.library.BuildFieldsProvider;
import com.instabug.library.Instabug;
import com.instabug.library.h;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.internal.device.a;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.d;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class DeviceStateProvider {
    @Nullable
    private static WeakReference<File> externalStorageDirWeakRef;

    public static String getDevice() {
        return InstabugDeviceProperties.getDeviceType();
    }

    public static boolean isDeviceRooted() {
        try {
            return a.d();
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-Core", "Something went wrong while checking if device is rooted or not " + exception.getMessage());
            return false;
        }
    }

    @NonNull
    public static String getOS() {
        return "OS Level " + Build.VERSION.SDK_INT;
    }

    public static String getCarrier(Context context) {
        try {
            return ((TelephonyManager)context.getSystemService("phone")).getNetworkOperatorName();
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-Core", "Got error while get Carrier", exception);
            return "Unknown";
        }
    }

    public static String getAppPackageName(Context context) {
        return InstabugDeviceProperties.getPackageName(context);
    }

    public static String getAppVersion(Context context) {
        PackageInfo packageInfo = InstabugDeviceProperties.getPackageInfo(context);
        Object object = packageInfo.versionName;
        Integer n2 = packageInfo.versionCode;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object;
        objectArray[1] = n2;
        return d.a(String.format("%s (%s)", objectArray2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static int getBatteryLevel(Context context) {
        Exception exception2;
        block5: {
            IntentFilter intentFilter;
            Context context2;
            try {
                context2 = context;
            }
            catch (Exception exception2) {}
            Context context3 = intentFilter;
            intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            context3 = context2.registerReceiver(null, (IntentFilter)context3);
            if (context3 == null) break block5;
            Context context4 = context3;
            int n2 = context4.getIntExtra("level", -1);
            return (int)((float)n2 / (float)context4.getIntExtra("scale", -1) * 100.0f);
        }
        InstabugSDKLogger.d("IBG-Core", "Could't obtain battery level");
        return -1;
        InstabugSDKLogger.e("IBG-Core", "Got error while get battery level", exception2);
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static String getBatteryState(Context context) {
        Exception exception2;
        block9: {
            block7: {
                int n2;
                Context context2;
                block8: {
                    IntentFilter intentFilter;
                    Context context3;
                    try {
                        context3 = context;
                    }
                    catch (Exception exception2) {}
                    context2 = intentFilter;
                    intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
                    context2 = context3.registerReceiver(null, (IntentFilter)context2);
                    if (context2 == null) break block7;
                    n2 = context2.getIntExtra("status", -1);
                    if (n2 != 2 && n2 != 5) {
                        n2 = 0;
                        break block8;
                    }
                    n2 = 1;
                }
                int n3 = context2.getIntExtra("plugged", -1);
                boolean bl = n3 == 2;
                n3 = n3 == 1 ? 1 : 0;
                if (n2 == 0) return "Unplugged";
                CharSequence charSequence = new StringBuilder().append("Charging");
                String string2 = n3 != 0 ? " through AC Charger" : (bl ? " through USB cable" : "");
                break block9;
                String string3 = string2;
                String string4 = ((StringBuilder)charSequence).append(string3).toString();
                return string4;
            }
            InstabugSDKLogger.d("IBG-Core", "Could't obtain battery state");
            return "Unknown";
        }
        InstabugSDKLogger.e("IBG-Core", "Got error while get battery state", exception2);
        return "Unknown";
    }

    public static boolean getWifiState(Context context) {
        Exception exception2;
        block5: {
            boolean bl;
            block4: {
                block3: {
                    Context context2;
                    try {
                        context2 = ((ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(1);
                        if (context2 == null) break block3;
                    }
                    catch (Exception exception2) {
                        break block5;
                    }
                    if (!context2.isConnected()) break block3;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            return bl;
        }
        InstabugSDKLogger.e("IBG-Core", "Got error while get wifi state", exception2);
        return false;
    }

    public static long getFreeMemory(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        Context context2 = memoryInfo;
        ((ActivityManager)context.getSystemService("activity")).getMemoryInfo(new ActivityManager.MemoryInfo());
        return context2.availMem / 0x100000L;
    }

    public static long getUsedMemory(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        Context context2 = context;
        Context context3 = memoryInfo;
        ((ActivityManager)context2.getSystemService("activity")).getMemoryInfo(new ActivityManager.MemoryInfo());
        return (DeviceStateProvider.calculateTotalMemory(context2) - context3.availMem) / 0x100000L;
    }

    public static long getTotalMemory(Context context) {
        long l2 = DeviceStateProvider.calculateTotalMemory(context);
        if (l2 == 0L) {
            InstabugSDKLogger.e("IBG-Core", "Got error while calculating total memory");
            return -1L;
        }
        return l2 / 0x100000L;
    }

    private static long calculateTotalMemory(Context context) {
        if (BuildFieldsProvider.INSTANCE.provideBuildVersion() >= 16) {
            Context context2;
            return DeviceStateProvider.calculateTotalMemoryApi16(context2);
        }
        return DeviceStateProvider.calculateTotalMemoryPreApi16();
    }

    @TargetApi(value=16)
    private static long calculateTotalMemoryApi16(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        Context context2 = memoryInfo;
        ((ActivityManager)context.getSystemService("activity")).getMemoryInfo(new ActivityManager.MemoryInfo());
        return context2.totalMem;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long calculateTotalMemoryPreApi16() {
        block16: {
            var0 = null;
            var1_3 = v0;
            v0 = new RandomAccessFile("/proc/meminfo", "r");
            v1 = v0.readLine().split(":")[1].trim();
            var0 = v1.substring(0, v1.length() - 3).trim();
            v0.close();
            var0_1 = Long.parseLong((String)var0) * 1024L;
            try {
                v0.close();
                return var0_1;
            }
            catch (IOException v2) {
                v2.printStackTrace();
            }
            return var0_1;
            catch (Throwable var0_2) {
                break block16;
            }
            catch (IOException v3) {
                var0 = var1_3;
                ** GOTO lbl-1000
            }
            catch (Throwable var1_4) {
                var1_3 = var0;
                var0 = var1_4;
                break block16;
            }
            catch (IOException v3) {
                // empty catch block
            }
lbl-1000:
            // 2 sources

            {
                v3.printStackTrace();
                if (var0 == null) return 0L;
            }
            try {
                var0.close();
                return 0L;
            }
            catch (IOException v4) {
                v4.printStackTrace();
            }
            return 0L;
        }
        if (var1_3 == null) throw var0;
        try {
            var1_3.close();
            throw var0;
        }
        catch (IOException v5) {
            v5.printStackTrace();
        }
        throw var0;
    }

    public static long getFreeInternalStorage() {
        Object object = DeviceStateProvider.getApplicationContext();
        if (object != null) {
            if ((object = object.getFilesDir()) != null) {
                return ((File)object).getUsableSpace() / 0x100000L;
            }
            InstabugSDKLogger.e("IBG-Core", "Got Error while calculating free storage");
            return -1L;
        }
        InstabugSDKLogger.e("IBG-Core", "Context was null while calculating free storage");
        return -1L;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getFreeStorage() {
        block4: {
            try {
                File file = DeviceStateProvider.getExternalCacheDir();
                if (DeviceStateProvider.externalMemoryAvailable() && file != null) {
                    return file.getUsableSpace() / 0x100000L;
                }
            }
            catch (Exception exception) {
                break block4;
            }
            {
                InstabugSDKLogger.e("IBG-Core", "Got error while calculate free storage");
                return -1L;
            }
        }
        InstabugSDKLogger.e("IBG-Core", "Got error while calculate free storage");
        return -1L;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getUsedStorage() {
        block5: {
            try {
                File file = DeviceStateProvider.getExternalCacheDir();
                if (DeviceStateProvider.externalMemoryAvailable() && file != null) {
                    long l2 = file.getTotalSpace() - file.getFreeSpace();
                    return l2 / 0x100000L;
                }
            }
            catch (Exception exception) {
                break block5;
            }
            {
                InstabugSDKLogger.e("IBG-Core", "Got error while calculate used storage");
                return -1L;
            }
        }
        InstabugSDKLogger.e("IBG-Core", "Got error while calculate used storage");
        return -1L;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getTotalStorage() {
        block4: {
            try {
                File file = DeviceStateProvider.getExternalCacheDir();
                if (DeviceStateProvider.externalMemoryAvailable() && file != null) {
                    return (int)(file.getTotalSpace() / 0x100000L);
                }
            }
            catch (Exception exception) {
                break block4;
            }
            {
                InstabugSDKLogger.e("IBG-Core", "Got error while calculate total storage");
                return -1L;
            }
        }
        InstabugSDKLogger.e("IBG-Core", "Got error while calculate total storage");
        return -1L;
    }

    @Nullable
    private static File getExternalCacheDir() {
        Object object = DeviceStateProvider.getApplicationContext();
        if (object == null) {
            return null;
        }
        WeakReference<File> weakReference = externalStorageDirWeakRef;
        if ((weakReference == null || weakReference.get() == null) && (object = object.getExternalCacheDir()) != null) {
            externalStorageDirWeakRef = new WeakReference<Object>(object);
        }
        return (object = externalStorageDirWeakRef) != null ? (File)((Reference)object).get() : null;
    }

    @Nullable
    private static Context getApplicationContext() {
        return Instabug.getApplicationContext();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean externalMemoryAvailable() {
        void var0_2;
        try {
            return Environment.getExternalStorageState().equals("mounted");
        }
        catch (Exception exception) {
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        InstabugSDKLogger.e("IBG-Core", "Couldn't get external Memory Available", (Throwable)var0_2);
        return false;
    }

    public static String getScreenDensity(Context context) {
        int n2 = DeviceStateProvider.getDisplayMetrics((Context)context).densityDpi;
        if (n2 < 160) {
            return "ldpi";
        }
        if (n2 < 240) {
            return "mdpi";
        }
        if (n2 < 320) {
            return "hdpi";
        }
        if (n2 < 480) {
            return "xhdpi";
        }
        if (n2 < 640) {
            return "xxhdpi";
        }
        return "xxxhdpi";
    }

    public static String getScreenSize(Context context) {
        DisplayMetrics displayMetrics = DeviceStateProvider.getDisplayMetrics(context);
        Object object = displayMetrics.widthPixels;
        Integer n2 = displayMetrics.heightPixels;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object;
        objectArray[1] = n2;
        return String.format("%sx%s", objectArray2);
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        Context context2;
        DisplayMetrics displayMetrics;
        DisplayMetrics displayMetrics2 = displayMetrics;
        displayMetrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            ((DisplayManager)context2.getSystemService("display")).getDisplay(0).getRealMetrics(displayMetrics2);
        } else {
            ((WindowManager)context2.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics2);
        }
        return displayMetrics2;
    }

    public static String getScreenOrientation(Context context) {
        if (context.getResources().getConfiguration().orientation == 2) {
            return "landscape";
        }
        return "portrait";
    }

    public static String getSdkVersion() {
        return "15.0.0";
    }

    public static String getLocale(Context context) {
        Context context2;
        if (ConfigurationCompat.getLocales((Configuration)context.getResources().getConfiguration()).size() > 0) {
            return ConfigurationCompat.getLocales((Configuration)context2.getResources().getConfiguration()).get(0).toString();
        }
        return context2.getResources().getConfiguration().locale.toString();
    }

    public static long getActiveSessionDuration() {
        return h.e().d();
    }

    public static String getDeviceArchitecture() {
        return Build.CPU_ABI;
    }

    public static int getOSVersion() {
        return Build.VERSION.SDK_INT;
    }
}

