package com.instabug.library.util.threading;

import androidx.annotation.Nullable;

/**
 * Interface definition for a callback to be invoked when a thread pool reaches idle state.
 */
public interface ThreadPoolIdleListener {
    /**
     * Called when a thread pool reaches idle state
     *
     * @param identifier The identifier of the thread pool.
     */
    void onPoolReachIdleState(@Nullable String identifier);
}
