package com.instabug.library.util.extenstions

import android.database.Cursor

fun Cursor.getBoolean(columnIndex: Int) = getInt(columnIndex).asBoolean
fun Cursor.getBoolean(key: String) = getInt(getColumnIndexOrThrow(key)).asBoolean
fun Cursor.getString(key: String): String = getString(getColumnIndexOrThrow(key))
fun Cursor.getNullableString(key: String): String? = getString(getColumnIndexOrThrow(key))
fun Cursor.getLong(key: String) = getLong(getColumnIndexOrThrow(key))
fun Cursor.getInt(key: String) = getInt(getColumnIndexOrThrow(key))