package com.instabug.library.tracking

interface ActiveScreenEvaluator {
    fun getActiveScreenName(screensRoot: ScreenChildrenOwner): String
    fun isCurrentlyActive(screensRoot: ScreenChildrenOwner, nodeId: Int): Boolean
}

abstract class AbstractActiveScreenEvaluator : ActiveScreenEvaluator {

    final override fun getActiveScreenName(screensRoot: ScreenChildrenOwner): String =
        getActiveNode(screensRoot)?.fullName ?: "NA"

    final override fun isCurrentlyActive(screensRoot: ScreenChildrenOwner, nodeId: Int): Boolean =
        getActiveNode(screensRoot)?.id == nodeId

    protected abstract fun getActiveNode(screensRoot: ScreenChildrenOwner): ScreenNode?
}

object LatestVisibleEvaluator : AbstractActiveScreenEvaluator() {

    override fun getActiveNode(screensRoot: ScreenChildrenOwner): ScreenNode? {
        var activeNode: ScreenNode? = null
        ScreenChildrenOwner.Helper.traverseBreadth(
            screensRoot,
            criteria = { it.isVisible && it.activationTime > 0 }
        ) { examinationNode -> activeNode = compareAndSelect(activeNode, examinationNode) }
        return activeNode
    }

    private fun compareAndSelect(active: ScreenNode?, examination: ScreenNode): ScreenNode {
        if (active == null) return examination
        if (active.activationTime > examination.activationTime) return active
        return examination
    }
}