package com.instabug.library.screenshot.subscribers

import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable
import com.instabug.library.core.eventbus.instabugeventbus.InstabugEventBus
import com.instabug.library.internal.servicelocator.CoreServiceLocator.commonAnalyticsCollector
import com.instabug.library.screenshot.analytics.AnalyticsEvent

object ScreenshotsAnalyticsEventBus : InstabugEventBus<AnalyticsEvent>()

object IBGScreenshotsAnalyticsSubscriber {
    var disposable: IBGDisposable? = null

    @JvmStatic
    fun subscribeToCommonAnalyticsCollector() {
        if (disposable == null) {
            disposable = ScreenshotsAnalyticsEventBus.subscribe(commonAnalyticsCollector)
        }
    }

    @JvmStatic
    fun unSubscribe() {
        disposable?.dispose()
        disposable = null
    }


}