package com.instabug.library.model;

import static com.instabug.library.model.StepType.ACTIVITY_CREATED;
import static com.instabug.library.model.StepType.ACTIVITY_DESTROYED;
import static com.instabug.library.model.StepType.ACTIVITY_PAUSED;
import static com.instabug.library.model.StepType.ACTIVITY_RESUMED;
import static com.instabug.library.model.StepType.ACTIVITY_STARTED;
import static com.instabug.library.model.StepType.ACTIVITY_STOPPED;
import static com.instabug.library.model.StepType.APPLICATION_BACKGROUND;
import static com.instabug.library.model.StepType.APPLICATION_CREATED;
import static com.instabug.library.model.StepType.APPLICATION_FOREGROUND;
import static com.instabug.library.model.StepType.COMPOSE_DISPOSED;
import static com.instabug.library.model.StepType.COMPOSE_PAUSED;
import static com.instabug.library.model.StepType.COMPOSE_RESUMED;
import static com.instabug.library.model.StepType.COMPOSE_STARTED;
import static com.instabug.library.model.StepType.COMPOSE_STOPPED;
import static com.instabug.library.model.StepType.DIALOG_FRAGMENT_RESUMED;
import static com.instabug.library.model.StepType.DISABLE;
import static com.instabug.library.model.StepType.DOUBLE_TAP;
import static com.instabug.library.model.StepType.ENABLE;
import static com.instabug.library.model.StepType.END_EDITING;
import static com.instabug.library.model.StepType.FLING;
import static com.instabug.library.model.StepType.FRAGMENT_ATTACHED;
import static com.instabug.library.model.StepType.FRAGMENT_DETACHED;
import static com.instabug.library.model.StepType.FRAGMENT_PAUSED;
import static com.instabug.library.model.StepType.FRAGMENT_RESUMED;
import static com.instabug.library.model.StepType.FRAGMENT_STARTED;
import static com.instabug.library.model.StepType.FRAGMENT_STOPPED;
import static com.instabug.library.model.StepType.FRAGMENT_VIEW_CREATED;
import static com.instabug.library.model.StepType.FRAGMENT_VISIBILITY_CHANGED;
import static com.instabug.library.model.StepType.LONG_PRESS;
import static com.instabug.library.model.StepType.MOVE;
import static com.instabug.library.model.StepType.OPEN_DIALOG;
import static com.instabug.library.model.StepType.PINCH;
import static com.instabug.library.model.StepType.SCROLL;
import static com.instabug.library.model.StepType.SHAKE;
import static com.instabug.library.model.StepType.START_EDITING;
import static com.instabug.library.model.StepType.SWIPE;
import static com.instabug.library.model.StepType.TAB_SELECT;
import static com.instabug.library.model.StepType.TAP;
import static com.instabug.library.model.StepType.UNKNOWN;

import androidx.annotation.Keep;
import androidx.annotation.StringDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@StringDef({UNKNOWN, APPLICATION_CREATED, ACTIVITY_CREATED, ACTIVITY_STARTED, ACTIVITY_RESUMED,
        ACTIVITY_PAUSED, ACTIVITY_STOPPED, ACTIVITY_DESTROYED, OPEN_DIALOG, FRAGMENT_ATTACHED, FRAGMENT_VIEW_CREATED,
        FRAGMENT_STARTED, FRAGMENT_RESUMED, FRAGMENT_PAUSED, FRAGMENT_STOPPED, FRAGMENT_DETACHED, FRAGMENT_VISIBILITY_CHANGED,
        SHAKE, TAP, DOUBLE_TAP, LONG_PRESS, FLING, SCROLL, SWIPE, PINCH, APPLICATION_BACKGROUND, APPLICATION_FOREGROUND,
        ENABLE, DISABLE, START_EDITING, END_EDITING, MOVE, TAB_SELECT, DIALOG_FRAGMENT_RESUMED,
        COMPOSE_STARTED, COMPOSE_RESUMED, COMPOSE_PAUSED, COMPOSE_STOPPED,COMPOSE_DISPOSED})
@Retention(RetentionPolicy.SOURCE)
@Keep
public @interface StepType {

    String UNKNOWN = "UNKNOWN";
    String APPLICATION_CREATED = "APPLICATION_CREATED";
    String ACTIVITY_CREATED = "ACTIVITY_CREATED";
    String ACTIVITY_STARTED = "ACTIVITY_STARTED";
    String ACTIVITY_RESUMED = "ACTIVITY_RESUMED";
    String ACTIVITY_PAUSED = "ACTIVITY_PAUSED";
    String ACTIVITY_STOPPED = "ACTIVITY_STOPPED";
    String ACTIVITY_DESTROYED = "ACTIVITY_DESTROYED";
    String OPEN_DIALOG = "OPEN_DIALOG";
    String FRAGMENT_ATTACHED = "FRAGMENT_ATTACHED";
    String FRAGMENT_VIEW_CREATED = "FRAGMENT_VIEW_CREATED";
    String FRAGMENT_STARTED = "FRAGMENT_STARTED";
    String FRAGMENT_RESUMED = "FRAGMENT_RESUMED";
    String FRAGMENT_PAUSED = "FRAGMENT_PAUSED";
    String FRAGMENT_STOPPED = "FRAGMENT_STOPPED";
    String FRAGMENT_DETACHED = "FRAGMENT_DETACHED";
    String FRAGMENT_VISIBILITY_CHANGED = "FRAGMENT_VISIBILITY_CHANGED";
    String SHAKE = "SHAKE";
    String TAP = "TAP";
    String DOUBLE_TAP = "DOUBLE_TAP";
    String LONG_PRESS = "LONG_PRESS";
    String FLING = "FLING";
    String SCROLL = "SCROLL";
    String SWIPE = "SWIPE";
    String PINCH = "PINCH";
    String APPLICATION_BACKGROUND = "APPLICATION_BACKGROUND";
    String APPLICATION_FOREGROUND = "APPLICATION_FOREGROUND";
    String ENABLE = "ENABLE";
    String DISABLE = "DISABLE";
    String START_EDITING = "START_EDITING";
    String END_EDITING = "END_EDITING";
    String MOVE = "MOVE";
    String TAB_SELECT = "TAB_SELECT";
    String DIALOG_FRAGMENT_RESUMED = "DIALOG_FRAGMENT_RESUMED";
    //Compose
    String COMPOSE_STARTED = "COMPOSE_STARTED";

    String COMPOSE_RESUMED = "COMPOSE_RESUMED";

    String COMPOSE_PAUSED = "COMPOSE_PAUSED";
    String COMPOSE_STOPPED = "COMPOSE_STOPPED";
    String COMPOSE_DISPOSED = "COMPOSE_DISPOSED";
}
