package com.instabug.library.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * A model that hold the device details to be written as log descriptor in every session start.
 */
public class LogDescriptor {
    private final static String SESSION_PREFIX = "session started";

    // KEYS
    private final static String APP_TOKEN_KEY = "AppToken: ";
    private final static String OS_VERSION_KEY = "OS Version: ";
    private final static String SDK_VERSION_KEY = "sdk version: ";
    private final static String FREE_MEMORY_KEY = "free memory: ";

    @Nullable
    private String appToken;
    @Nullable
    private String osVersion;
    @Nullable
    private String sdkVersion;
    private long freeMemory;


    public LogDescriptor(@Nullable String appToken, @Nullable String osVersion, @Nullable String sdkVersion,
                         long freeMemory) {
        this.appToken = appToken;
        this.osVersion = osVersion;
        this.sdkVersion = sdkVersion;
        this.freeMemory = freeMemory;
    }

    @Nullable
    public String getAppToken() {
        return appToken;
    }

    @Nullable
    public String getOsVersion() {
        return osVersion;
    }

    @Nullable
    public String getSdkVersion() {
        return sdkVersion;
    }

    public long getFreeMemory() {
        return freeMemory;
    }

    public static class Builder {

        @Nullable
        private String appToken;
        @Nullable
        private String osVersion;
        @Nullable
        private String sdkVersion;
        private long freeMemory;

        public Builder() {

        }

        public Builder setAppToken(String appToken) {
            this.appToken = appToken;
            return this;
        }

        public Builder setOsVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public Builder setSdkVersion(String sdkVersion) {
            this.sdkVersion = sdkVersion;
            return this;
        }

        public Builder setFreeMemory(long freeMemory) {
            this.freeMemory = freeMemory;
            return this;
        }

        public LogDescriptor build() {
            return new LogDescriptor(appToken, osVersion, sdkVersion, freeMemory);
        }
    }

    @NonNull
    @Override
    public String toString() {
        return "\n"
                + SESSION_PREFIX
                + "\n"
                + APP_TOKEN_KEY + getAppToken()
                + "\n"
                + OS_VERSION_KEY + getOsVersion()
                + "\n"
                + SDK_VERSION_KEY + getSdkVersion()
                + "\n"
                + FREE_MEMORY_KEY + getFreeMemory()
                + "\n"
                + "\n";
    }
}
