package com.instabug.library.model;

import java.io.File;
import java.io.Serializable;

/**
 * @author mesbah
 */
public class AssetEntity implements Serializable {

    public enum AssetType {
        IMAGE, AUDIO, VIDEO
    }

    private String key;
    private AssetType type;
    private String url;
    private File file;

    public AssetEntity(String key, AssetType type, String url, File file) {
        this.key = key;
        this.type = type;
        this.url = url;
        this.file = file;
    }

    public String getKey() {
        return key;
    }

    public AssetType getType() {
        return type;
    }

    public String getUrl() {
        return url;
    }

    public File getFile() {
        return file;
    }
}
