package com.instabug.library.internal.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.widget.TextView;

import com.instabug.library.util.DrawingUtility;

/**
 * Created by Tarek on 1/29/17.
 */

public class BubbleTextView extends TextView {

  private RectF rectF;
  private Paint paint;
  private final static float ARROW_LENGTH_DP = 7; // 7dp
  private float arrowLengthPx;
  private PointF arrowSidePoint;
  private PointF arrowTopPoint;
  private PointF arrowBottomPoint;
  private Path arrowPath;
  private float cornerRadius;

  public BubbleTextView(Context context) {
    super(context);
    init();
  }

  public BubbleTextView(Context context, AttributeSet attrs) {
    super(context, attrs);
    init();
  }

  public BubbleTextView(Context context, AttributeSet attrs, int defStyle) {
    super(context, attrs, defStyle);
    init();
  }

  private void init() {

    setTextColor(Color.WHITE);
    rectF = new RectF();
    paint = new Paint(Paint.ANTI_ALIAS_FLAG);
    paint.setColor(Color.DKGRAY);
    paint.setStyle(Paint.Style.FILL);

    arrowLengthPx = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, ARROW_LENGTH_DP,
        getContext().getResources().getDisplayMetrics());
    cornerRadius = arrowLengthPx / 2;
    int verticalPadding = (int) arrowLengthPx;
    int leftPadding = (int) (1.5 * arrowLengthPx);
    int rightPadding = (int) (1.5 * arrowLengthPx + arrowLengthPx);

    setPadding(leftPadding, verticalPadding, rightPadding, verticalPadding);
    arrowSidePoint = new PointF();
    arrowTopPoint = new PointF();
    arrowBottomPoint = new PointF();
    arrowPath = new Path();
  }

  @Override protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
    super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    int width;
    int height;
    height = getMeasuredHeight();

    width = getMeasuredWidth();

    setMeasuredDimension(width, height);

    rectF.right = width - arrowLengthPx;
    rectF.bottom = height;

    arrowSidePoint.x = width;
    arrowSidePoint.y = rectF.centerY();

    float length = (float) (arrowLengthPx / Math.cos(45));
    DrawingUtility.pointOnCircle(length, 225, arrowSidePoint, arrowTopPoint);

    DrawingUtility.pointOnCircle(length, 135, arrowSidePoint, arrowBottomPoint);

    arrowPath.moveTo(arrowTopPoint.x, arrowTopPoint.y);
    arrowPath.lineTo(arrowSidePoint.x, arrowSidePoint.y);
    arrowPath.lineTo(arrowBottomPoint.x, arrowBottomPoint.y);
    arrowPath.close();
  }

  @Override protected void onDraw(Canvas canvas) {
    canvas.drawRoundRect(rectF, cornerRadius, cornerRadius, paint);
    canvas.drawPath(arrowPath, paint);
    super.onDraw(canvas);
  }
}
