package com.instabug.library.internal.video;

import android.net.Uri;

import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;

import java.io.File;

import androidx.annotation.Nullable;

/**
 * Created by vezikon on 5/3/17.
 */

public class ScreenRecordingFileHolder {

    private static final ScreenRecordingFileHolder INSTANCE = new ScreenRecordingFileHolder();

    @Nullable
    private File autoScreenRecordingFile;

    public static ScreenRecordingFileHolder getInstance() {
        return INSTANCE;
    }

    public ScreenRecordingFileHolder() {
    }

    @Nullable
    public Uri getAutoScreenRecordingFileUri() {
        if (autoScreenRecordingFile != null) {
            return Uri.fromFile(autoScreenRecordingFile);
        } else {
            return null;
        }
    }

    public void setAutoScreenRecordingFile(@Nullable File autoScreenRecordingFile) {
        this.autoScreenRecordingFile = autoScreenRecordingFile;
    }

    public boolean delete() {
        if(autoScreenRecordingFile == null)
            return true;

        if (autoScreenRecordingFile.delete()) {
            InstabugSDKLogger.d(Constants.LOG_TAG, "Screen recording file deleted");
            return true;
        } else {
            return false;
        }
    }

    public void clear() {
        autoScreenRecordingFile = null;
    }
}
