package com.instabug.library.internal.utils.stability.execution;

import androidx.annotation.Nullable;

/**
 * A functional interface similar to Runnable but allows returning a value and throwing a checked exception.
 */
@FunctionalInterface
public interface ReturnableExecutable<T> {

    /**
     * Runs the action and optionally throws a checked exception.
     *
     * @return the operation results
     * @throws Exception if the implementation wishes to throw a checked exception
     */
    @Nullable
    T execute() throws Exception;
}
