package com.instabug.library.internal.storage.cache.dbv2;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.database.CharArrayBuffer;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;

import androidx.annotation.RequiresApi;

import com.instabug.library.encryption.EncryptionManager;

public class IBGCursor implements Cursor {

    private final Cursor cursor;

    public IBGCursor(Cursor cursor) {
        this.cursor = cursor;
    }


    @Override
    public int getCount() {
        return cursor.getCount();
    }

    @Override
    public int getPosition() {
        return cursor.getPosition();
    }

    @Override
    public boolean move(int offset) {
        return cursor.move(offset);
    }

    @Override
    public boolean moveToPosition(int position) {
        return cursor.moveToPosition(position);
    }

    @Override
    public boolean moveToFirst() {
        return cursor.moveToFirst();
    }

    @Override
    public boolean moveToLast() {
        return cursor.moveToLast();
    }

    @Override
    public boolean moveToNext() {
        return cursor.moveToNext();
    }

    @Override
    public boolean moveToPrevious() {
        return cursor.moveToPrevious();
    }

    @Override
    public boolean isFirst() {
        return cursor.isFirst();
    }

    @Override
    public boolean isLast() {
        return cursor.isLast();
    }

    @Override
    public boolean isBeforeFirst() {
        return cursor.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() {
        return cursor.isAfterLast();
    }

    @Override
    public int getColumnIndex(String columnName) {
        return cursor.getColumnIndex(columnName);
    }

    @Override
    public int getColumnIndexOrThrow(String columnName) throws IllegalArgumentException {
        return cursor.getColumnIndexOrThrow(columnName);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return cursor.getColumnName(columnIndex);
    }

    @Override
    public String[] getColumnNames() {
        return cursor.getColumnNames();
    }

    @Override
    public int getColumnCount() {
        return cursor.getColumnCount();
    }

    @Override
    public byte[] getBlob(int columnIndex) {
        return cursor.getBlob(columnIndex);
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    @Override
    public String getString(int columnIndex) {
        return EncryptionManager.decrypt(cursor.getString(columnIndex), EncryptionManager.IV_V2);
    }

    @Override
    public void copyStringToBuffer(int columnIndex, CharArrayBuffer buffer) {
        cursor.copyStringToBuffer(columnIndex, buffer);
    }

    @Override
    public short getShort(int columnIndex) {
        String decryptedValue = EncryptionManager.decrypt(cursor.getString(columnIndex), EncryptionManager.IV_V2);
        if (decryptedValue == null) {
            return 0;
        } else {
            try {
                return Short.parseShort(decryptedValue);
            } catch (NumberFormatException exception) {
                return 0;
            }
        }
    }

    @Override
    public int getInt(int columnIndex) {
        String decryptedValue = EncryptionManager.decrypt(cursor.getString(columnIndex), EncryptionManager.IV_V2);
        if (decryptedValue == null) {
            return 0;
        } else {
            try {
                return Integer.parseInt(decryptedValue);
            } catch (NumberFormatException exception) {
                return 0;
            }
        }
    }

    @Override
    public long getLong(int columnIndex) {
        String decryptedValue = EncryptionManager.decrypt(cursor.getString(columnIndex), EncryptionManager.IV_V2);
        if (decryptedValue == null) {
            return 0;
        } else {
            try {
                return Long.parseLong(decryptedValue);
            } catch (NumberFormatException exception) {
                return 0;
            }
        }
    }

    @Override
    public float getFloat(int columnIndex) {
        String decryptedValue = EncryptionManager.decrypt(cursor.getString(columnIndex), EncryptionManager.IV_V2);
        if (decryptedValue == null) {
            return 0;
        } else {
            try {
                return Float.parseFloat(decryptedValue);
            } catch (NumberFormatException exception) {
                return 0;
            }
        }
    }

    @Override
    public double getDouble(int columnIndex) {
        String decryptedValue = EncryptionManager.decrypt(cursor.getString(columnIndex), EncryptionManager.IV_V2);
        if (decryptedValue == null) {
            return 0;
        } else {
            try {
                return Double.parseDouble(decryptedValue);
            } catch (NumberFormatException exception) {
                return 0;
            }
        }
    }

    @Override
    public int getType(int columnIndex) {
        return cursor.getType(columnIndex);
    }

    @Override
    public boolean isNull(int columnIndex) {
        return cursor.isNull(columnIndex);
    }

    @Override
    public void deactivate() {
        cursor.deactivate();
    }

    @Override
    public boolean requery() {
        return cursor.requery();
    }

    @Override
    public void close() {
        cursor.close();
    }

    @Override
    public boolean isClosed() {
        return cursor.isClosed();
    }

    @Override
    public void registerContentObserver(ContentObserver observer) {
        cursor.registerContentObserver(observer);
    }

    @Override
    public void unregisterContentObserver(ContentObserver observer) {
        cursor.unregisterContentObserver(observer);
    }

    @Override
    public void registerDataSetObserver(DataSetObserver observer) {
        cursor.registerDataSetObserver(observer);
    }

    @Override
    public void unregisterDataSetObserver(DataSetObserver observer) {
        cursor.unregisterDataSetObserver(observer);
    }

    @Override
    public void setNotificationUri(ContentResolver cr, Uri uri) {
        cursor.setNotificationUri(cr, uri);
    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    public Uri getNotificationUri() {
        return cursor.getNotificationUri();
    }

    @Override
    public boolean getWantsAllOnMoveCalls() {
        return cursor.getWantsAllOnMoveCalls();
    }

    @RequiresApi(api = Build.VERSION_CODES.M)
    @Override
    public void setExtras(Bundle extras) {
        cursor.setExtras(extras);
    }

    @Override
    public Bundle getExtras() {
        return cursor.getExtras();
    }

    @Override
    public Bundle respond(Bundle extras) {
        return cursor.respond(extras);
    }
}
