package com.instabug.library.internal.sharedpreferences

import android.content.SharedPreferences
import com.instabug.library.internal.sharedpreferences.ReadWriteStrategyPreferenceProperty.ReadWriteStrategy

class DefaultReadWriteStrategy<T> : ReadWriteStrategy<T> {

    @Suppress("UNCHECKED_CAST")
    override fun SharedPreferences.get(key: String, default: T): T =
        when (default) {
            is String -> getString(key, default)
            is Float -> getFloat(key, default)
            is Int -> getInt(key, default)
            is Long -> getLong(key, default)
            is Boolean -> getBoolean(key, default)
            is Set<*> -> getStringSet(key, default as Set<String>)
            else -> throw UnsupportedOperationException("can't persist non-primitive type")
        } as T

    override fun SharedPreferences.Editor.put(key: String, value: T): SharedPreferences.Editor {
        when (value) {
            is String -> putString(key, value)
            is Float -> putFloat(key, value)
            is Int -> putInt(key, value)
            is Long -> putLong(key, value)
            is Boolean -> putBoolean(key, value)
            is Set<*> -> putStringSet(key, value as Set<String>)
        }
        return this
    }
}