package com.instabug.library.internal.orchestrator;

import com.instabug.library.internal.dataretention.DataGarbageCollector;
import com.instabug.library.internal.dataretention.core.DataInspector;
import com.instabug.library.internal.dataretention.core.Disposable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

import androidx.annotation.NonNull;

public class DisposeDataAction implements Action {

    private final Collection<DataInspector<?>> inspectors;

    public DisposeDataAction(@NonNull DataInspector<?> inspector,
                             @NonNull DataInspector<?>... additionalInspectors) {
        if (additionalInspectors.length == 0) {
            inspectors = Collections.<DataInspector<?>>singleton(inspector);
        } else {
            inspectors = new LinkedList<>();
            inspectors.add(inspector);
            inspectors.addAll(Arrays.asList(additionalInspectors));
        }
    }

    @Override
    public void run() {
        DataGarbageCollector.Builder builder = DataGarbageCollector.builder();
        for (DataInspector<?> inspector : inspectors) {
            builder.withInspector(inspector);
        }
        DataGarbageCollector garbageCollector = builder.build();
        Disposable disposable = garbageCollector.collect();
        disposable.dispose();
    }
}
