package com.instabug.library.internal.module;

/**
 * @author mSobhy
 */
public enum InstabugLocale {
    ENGLISH("en"), ARABIC("ar"), GERMAN("de"), SPANISH("es"),
    FRENCH("fr"), ITALIAN("it"), JAPANESE("ja"), KOREAN("ko"),
    POLISH("pl"), PORTUGUESE_BRAZIL("pt", "BR"), PORTUGUESE_PORTUGAL("pt", "PT"),
    RUSSIAN("ru"), SWEDISH("sv"), TURKISH("tr"), SIMPLIFIED_CHINESE("zh", "CN"), TRADITIONAL_CHINESE("zh", "TW"),
    CZECH("cs"), PERSIAN("fa"), INDONESIAN("in"), DANISH("da"), SLOVAK("sk"), NETHERLANDS("nl"),
    NORWEGIAN("no"), FINNISH("fi"), AZERBAIJANI("az"), HUNGARIAN("hu"), CATALAN("ca"),
    CATALAN_SPAIN("ca", "ES"), ROMANIAN("ro");

    private final String code;
    private final String country;

    InstabugLocale(String code) {
        this.code = code;
        this.country = "";
    }

    InstabugLocale(String code, String country) {
        this.code = code;
        this.country = country;
    }

    public String getCode() {
        return code;
    }

    public String getCountry() {
        return country;
    }
}
