package com.instabug.library.internal.filestore

import com.instabug.library.util.extenstions.takeIfExists
import java.io.File

fun interface FileSelector<T : Directory> : FileOperation<T, File?>

class MostRecentFileSelector<T : Directory> : FileSelector<T> {
    override fun invoke(input: T): File? =
        input.listFiles()?.maxByOrNull { file -> file.lastModified() }
}

fun interface DirectorySelector<In : Directory, Out : Directory> : FileOperation<In, Out?>

class ActiveDirectorySelector<In : Directory>(
    private val directorySelector: DirectorySelector<In, Directory>
) : DirectorySelector<In, Directory> {
    override fun invoke(input: In): Directory? =
        input.let(directorySelector::invoke)?.takeIfExists()
}

fun interface MultiDirectorySelector<In : Directory, Out : Directory> : FileOperation<In, List<Out>>