package com.instabug.library

import com.instabug.library.Platform.ANDROID
import com.instabug.library.Platform.CORDOVA
import com.instabug.library.Platform.FLUTTER
import com.instabug.library.Platform.RN
import com.instabug.library.Platform.UNITY
import com.instabug.library.Platform.XAMARIN
import com.instabug.library.map.Mapper

class PlatformMapper : Mapper<Pair<String,Int>, Int> {
    override fun map(from: Pair<String,Int>): Int = when (from.first) {
        "ANDROID" -> ANDROID
        "RN" -> RN
        "XAMARIN" -> XAMARIN
        "CORDOVA" -> CORDOVA
        "UNITY" -> UNITY
        "FLUTTER" -> FLUTTER
        else -> from.second
    }
}