package com.instabug.library;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.HashMap;


/**
 * Created by vezikon on 6/25/16.
 */
public class InstabugCustomTextPlaceHolder {
    static final int TITLE_CHAR_LIMIT = 35;
    static final int SUB_TITLE_CHAR_LIMIT = 75;

    private final InstabugCustomTextPlaceHolderDelegate delegate;

    public InstabugCustomTextPlaceHolder() {
        this.delegate = new InstabugCustomTextPlaceHolderDelegate();
    }

    public void set(Key key, @NonNull String value) {
        delegate.set(key, value);
    }

    @Nullable
    public String get(Key key) {
        return delegate.get(key);
    }

    public void setPlaceHoldersMap(HashMap<Key, String> placeHoldersMap) {
        delegate.setMap(placeHoldersMap);
    }

    public enum Key {
        SHAKE_HINT, SWIPE_HINT, INVALID_EMAIL_MESSAGE, INVALID_COMMENT_MESSAGE, INVOCATION_HEADER,
        COMMENT_FIELD_INSUFFICIENT_CONTENT,
        /**
         * for prompt options
         */

        REPORT_BUG {
            int charLimit() {
                return TITLE_CHAR_LIMIT;
            }
        },
        REPORT_FEEDBACK {
            int charLimit() {
                return TITLE_CHAR_LIMIT;
            }
        },
        FRUSTRATING_EXPERIENCE_TITLE {
            int charLimit() {
                return TITLE_CHAR_LIMIT;
            }
        },
        REPORT_QUESTION {
            int charLimit() {
                return TITLE_CHAR_LIMIT;
            }
        },
        REQUEST_FEATURE {
            int charLimit() {
                return TITLE_CHAR_LIMIT;
            }
        },
        REPORT_BUG_DESCRIPTION {
            int charLimit() {
                return SUB_TITLE_CHAR_LIMIT;
            }
        },
        REPORT_FEEDBACK_DESCRIPTION {
            int charLimit() {
                return SUB_TITLE_CHAR_LIMIT;
            }
        },
        REPORT_QUESTION_DESCRIPTION {
            int charLimit() {
                return SUB_TITLE_CHAR_LIMIT;
            }
        },
        REQUEST_FEATURE_DESCRIPTION {
            int charLimit() {
                return SUB_TITLE_CHAR_LIMIT;
            }
        },
        EMAIL_FIELD_HINT,
        /**
         * for message hint in reporting
         */
        COMMENT_FIELD_HINT_FOR_BUG_REPORT, COMMENT_FIELD_HINT_FOR_FEEDBACK, COMMENT_FIELD_HINT_FOR_QUESTION, COMMENT_FIELD_HINT_FOR_FRUSTRATING_EXPERIENCE,

        ADD_VOICE_MESSAGE, ADD_IMAGE_FROM_GALLERY, ADD_EXTRA_SCREENSHOT, CONVERSATIONS_LIST_TITLE, AUDIO_RECORDING_PERMISSION_DENIED,
        CONVERSATION_TEXT_FIELD_HINT, VOICE_MESSAGE_PRESS_AND_HOLD_TO_RECORD,
        VOICE_MESSAGE_RELEASE_TO_ATTACH, REPORT_SUCCESSFULLY_SENT, SUCCESS_DIALOG_HEADER, ADD_VIDEO, VIDEO_RECORDING_FAB_BUBBLE_HINT,
        FEATURES_REQUEST, FEATURES_REQUEST_ADD_FEATURE_TOAST,
        FEATURES_REQUEST_ADD_FEATURE_THANKS_MESSAGE,
        SURVEYS_WELCOME_SCREEN_TITLE,
        SURVEYS_WELCOME_SCREEN_SUBTITLE,
        SURVEYS_WELCOME_SCREEN_BUTTON,
        SURVEYS_STORE_RATING_THANKS_TITLE,
        SURVEYS_STORE_RATING_THANKS_SUBTITLE,
        BETA_WELCOME_MESSAGE_WELCOME_STEP_TITLE, BETA_WELCOME_MESSAGE_WELCOME_STEP_CONTENT,
        BETA_WELCOME_MESSAGE_HOW_TO_REPORT_STEP_TITLE, BETA_WELCOME_MESSAGE_HOW_TO_REPORT_STEP_CONTENT,
        BETA_WELCOME_MESSAGE_FINISH_STEP_TITLE, BETA_WELCOME_MESSAGE_FINISH_STEP_CONTENT,
        LIVE_WELCOME_MESSAGE_TITLE, LIVE_WELCOME_MESSAGE_CONTENT, CHATS_TEAM_STRING_NAME,
        // for InAppNotifications
        REPLIES_NOTIFICATION_DISMISS_BUTTON,
        REPLIES_NOTIFICATION_REPLY_BUTTON,

        REPORT_DISCARD_DIALOG_TITLE,
        REPORT_DISCARD_DIALOG_BODY,
        REPORT_DISCARD_DIALOG_NEGATIVE_ACTION,
        REPORT_DISCARD_DIALOG_POSITIVE_ACTION,
        REPORT_ADD_ATTACHMENT_HEADER,
        REPORT_REPRO_STEPS_DISCLAIMER_BODY,
        REPORT_REPRO_STEPS_DISCLAIMER_LINK,

        REPRO_STEPS_PROGRESS_DIALOG_BODY,
        REPRO_STEPS_LIST_HEADER,
        REPRO_STEPS_LIST_DESCRIPTION,
        REPRO_STEPS_LIST_ITEM_NUMBERING_TITLE,
        REPRO_STEPS_LIST_EMPTY_STATE_DESCRIPTION,
        BUG_ATTACHMENT_DIALOG_OK_BUTTON,

        //Chats
        CHATS_TYPE_AUDIO,
        CHATS_TYPE_IMAGE,
        CHATS_TYPE_VIDEO,
        CHATS_MULTIPLE_MESSAGE_NOTIFICATION;

        int charLimit() {
            return -1;
        }
    }
}