package com.instabug.library.util;

import android.annotation.SuppressLint;
import android.net.Uri;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.Constants;
import com.instabug.library.Feature;
import com.instabug.library.IBGFeature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributeCacheManager;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributesDbHelper;
import com.instabug.library.logging.InstabugLog;
import com.instabug.library.model.Report;
import com.instabug.library.model.State;
import com.instabug.library.settings.SettingsManager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.instabug.library.core.InstabugCore.getFeatureState;

public class ReportHelper {


    @NonNull
    public static Report getReport(@Nullable Report.OnReportCreatedListener onReportCreatedListener) {
        Report report = new Report();
        if (onReportCreatedListener != null) {
            try {
                onReportCreatedListener.onReportCreated(report);
            } catch (Exception e) {
                InstabugSDKLogger.e(Constants.LOG_TAG, "Exception occurred in report Submit Handler ", e);
}
        }
        return report;
    }

    public static void update(@Nullable State state, Report report) {
        if (state == null)
            return;
        // set tags
        state.setTags(getAppendedUserTags(report.getTags()));
        // set console logs
        state.updateConsoleLog(report.getConsoleLog());
        // set file attachments
        for (Map.Entry<Uri, String> entry : report.getFileAttachments().entrySet()) {
            Uri uri = entry.getKey();
            String filename = entry.getValue();
            Instabug.addFileAttachment(uri, filename);
        }
        if (getFeatureState(IBGFeature.USER_DATA)
                == Feature.State.ENABLED) {
            // set user data
            if (report.getUserData() != null) {
                String userData = report.getUserData() == null ? Instabug.getUserData() : report.getUserData();
                state.setUserData(userData);
            }
        }

        // set user attributes
        state.setUserAttributes(getUserAppendedAttributes(report.getUserAttributes()));

        // set instabug logs
        if (getFeatureState(IBGFeature.INSTABUG_LOGS)
                == Feature.State.ENABLED) {
            state.setInstabugLog(InstabugLog.getLogs());
        }
    }

    @SuppressLint("NULL_DEREFERENCE")
    private static String getAppendedUserTags(List<String> tags) {
        if (SettingsManager.getInstance().getTags() != null) {
            SettingsManager.getInstance().getTags().addAll(tags);
        }
        return InstabugCore.getTagsAsString();
    }

    public static String getUserAppendedAttributes(Map<String, String> userAttributes) {
        for (Map.Entry<String, String> entry : userAttributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            UserAttributeCacheManager.insert(key, value);
        }
        return UserAttributesDbHelper.getSDKUserAttributes();
    }

}
