package com.instabug.library.tracking;

import android.content.Context;
import android.os.Bundle;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;

/**
 * Activity that extends {@link FragmentManager.FragmentLifecycleCallbacks}
 * This activity should be registered in {@link FragmentManager.registerFragmentLifecycleCallbacks}.
 *
 */
public class InstabugFragmentLifecycleListener extends FragmentManager.FragmentLifecycleCallbacks {


    @Override
    public void onFragmentAttached(@NonNull FragmentManager fm, @NonNull Fragment fragment, @NonNull Context context) {
        super.onFragmentAttached(fm, fragment, context);
        InstabugInternalTrackingDelegate.getInstance().onFragmentAttached(fragment);
    }

    @Override
    public void onFragmentViewCreated(@NonNull FragmentManager fm, @NonNull Fragment fragment, @NonNull View v, @Nullable Bundle savedInstanceState) {
        super.onFragmentViewCreated(fm, fragment, v, savedInstanceState);
        InstabugInternalTrackingDelegate.getInstance().onFragmentViewCreated(fragment);
    }

    @Override
    public void onFragmentStarted(@NonNull FragmentManager fm, @NonNull Fragment fragment) {
        super.onFragmentStarted(fm, fragment);
        InstabugInternalTrackingDelegate.getInstance().onFragmentStarted(fragment);
    }

    @Override
    public void onFragmentResumed(@NonNull FragmentManager fm, @NonNull Fragment fragment) {
        super.onFragmentResumed(fm, fragment);
        InstabugInternalTrackingDelegate.getInstance().onFragmentResumed(fragment);
    }

    @Override
    public void onFragmentPaused(@NonNull FragmentManager fm, @NonNull Fragment fragment) {
        super.onFragmentPaused(fm, fragment);
        InstabugInternalTrackingDelegate.getInstance().onFragmentPaused(fragment);
    }

    @Override
    public void onFragmentStopped(@NonNull FragmentManager fm, @NonNull Fragment fragment) {
        super.onFragmentStopped(fm, fragment);
        InstabugInternalTrackingDelegate.getInstance().onFragmentStopped(fragment);
    }

    @Override
    public void onFragmentDetached(@NonNull FragmentManager fm, @NonNull Fragment fragment) {
        super.onFragmentDetached(fm, fragment);
        InstabugInternalTrackingDelegate.getInstance().onFragmentDetached(fragment);
    }
}
