package com.instabug.library.settings

import android.content.Context
import android.content.SharedPreferences

class InstabugMinimalPersistableSettings(private val context: Context) {
    companion object {
        private const val SHARED_PREFERENCES_NAME = "instabug_minimal"
        private const val SDK_LAST_STATE_ENABLED_KEY = "sdk_last_state_enabled"
    }

    private val sharedPreferences: SharedPreferences by lazy {
        context.getSharedPreferences(
            SHARED_PREFERENCES_NAME,
            Context.MODE_PRIVATE
        )
    }

    private val editor: SharedPreferences.Editor by lazy { sharedPreferences.edit() }

    fun setLastSDKStateEnabled(enabled: Boolean) {
        editor.putBoolean(SDK_LAST_STATE_ENABLED_KEY, enabled).apply()
    }

    fun isLastSDKStateEnabled() = sharedPreferences.getBoolean(SDK_LAST_STATE_ENABLED_KEY, true)
}