package com.instabug.library.sessioncontroller

import com.instabug.library.Constants
import com.instabug.library.SessionManager
import com.instabug.library.core.InstabugCore
import com.instabug.library.model.v3Session.SessionEvent
import com.instabug.library.sessionV3.manager.IBGSessionManager
import com.instabug.library.util.InstabugSDKLogger

internal object SessionManualController {

    private val sessionManualControllerConfigs
        get() = SessionManualControllerServiceLocator.sessionManualControllerConfigs
    private val v2SessionManager: SessionManager
        get() = SessionManager.getInstance()
    private val v3SessionManager: IBGSessionManager
        get() = IBGSessionManager

    @JvmStatic
    fun startSession() {
        if (!isEnabled()) {
            logErrorMessage("Manual session control feature is disabled, start a new session call is ignored!")
            return
        } else if (InstabugCore.getRunningSession() != null) {
            logErrorMessage("Current session must end before starting a new one, start a new session call is ignored!")
            return
        }

        v2SessionManager.handleSessionStartEvent(true)
        v3SessionManager emit SessionEvent.Start(startedManually = true)
    }

    @JvmStatic
    fun stopSession() {
        if (!isEnabled()) {
            logErrorMessage("Manual session control feature is disabled, end a session call is ignored!")
            return
        } else if (InstabugCore.getRunningSession() == null) {
            logErrorMessage("There is no running session to end, end a session call is ignored!")
            return
        }

        v2SessionManager.stopCurrentSession()
        v3SessionManager emit SessionEvent.Stop()
    }

    @JvmStatic
    fun isEnabled(): Boolean {
        return sessionManualControllerConfigs.controlSessionManuallyEnabled
    }

    private fun logErrorMessage(message: String) {
        InstabugSDKLogger.e(Constants.LOG_TAG, message)
    }

}