package com.instabug.library.sessionV3.manager

import android.app.Activity
import android.content.ComponentCallbacks2
import android.os.Bundle
import com.instabug.library.Instabug
import com.instabug.library.internal.lifecycle.DefaultActivityLifecycleCallbacks
import com.instabug.library.internal.lifecycle.DefaultComponentCallbacks2
import com.instabug.library.internal.servicelocator.CoreServiceLocator
import com.instabug.library.internal.video.ServiceUtils
import com.instabug.library.model.v3Session.SessionEvent
import com.instabug.library.sessionV3.di.IBGSessionServiceLocator

object SessionLifecycleHandler : DefaultActivityLifecycleCallbacks, DefaultComponentCallbacks2 {

    private val activitiesCounter get() = CoreServiceLocator.startedActivitiesCounter
    private var inBackground: Boolean = true
    private val ratingDialogDetector
        get() = IBGSessionServiceLocator.ratingDialogDetector

    override fun onActivityCreated(activity: Activity, savedInstanceState: Bundle?) {
        ratingDialogDetector.init(activity)
    }

    override fun onActivityResumed(activity: Activity) {
        if (inBackground) startSession()
        ratingDialogDetector.startDetection(activity::class.simpleName)
    }

    override fun onActivityStopped(activity: Activity) {
        if (activitiesCounter.count == 0)
            handleSessionWhenNoVisibleActivities()
    }

    override fun onActivityDestroyed(activity: Activity) {
        ratingDialogDetector.endDetection(activity::class.simpleName)

        if (activitiesCounter.count == 0)
            handleSessionWhenNoVisibleActivities()
    }

    private fun handleSessionWhenNoVisibleActivities() {
        val hasForegroundServiceRunning = Instabug.getApplicationContext()
            ?.let(ServiceUtils::hasForegroundServiceRunning)
            ?: false
        if (hasForegroundServiceRunning)
            endSession()
    }

    private fun startSession() {
        IBGSessionManager emit SessionEvent.Start(isForeground = true)
        inBackground = false
    }

    private fun endSession() {
        IBGSessionManager emit SessionEvent.End()
        inBackground = true
    }

    override fun onTrimMemory(level: Int) {
        endSession()
    }
}