package com.instabug.library.percentagefeatures

import android.content.SharedPreferences
import com.instabug.library.internal.sharedpreferences.ReadWriteStrategyPreferenceProperty

class PercentageFeatureReadWriteStrategy :
    ReadWriteStrategyPreferenceProperty.ReadWriteStrategy<PercentageFeature?> {
    override fun SharedPreferences.get(
        key: String,
        default: PercentageFeature?
    ): PercentageFeature? =
        getString(key, null)?.let { PercentageFeature().apply { fromJson(it) } } ?: default

    override fun SharedPreferences.Editor.put(
        key: String,
        value: PercentageFeature?
    ): SharedPreferences.Editor = apply {
        value?.toJson().also { putString(key, it) }
    }

}