package com.instabug.library.networkv2;


import android.annotation.SuppressLint;

import androidx.annotation.IntDef;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.Map;

import static com.instabug.library.networkv2.RequestResponse.HttpStatusCode._2xx.OK;
import static com.instabug.library.networkv2.RequestResponse.HttpStatusCode._3xx.NOT_MODIFIED;
import static com.instabug.library.networkv2.RequestResponse.HttpStatusCode._4xx.BAD_REQUEST;
import static com.instabug.library.networkv2.RequestResponse.HttpStatusCode._4xx.RATE_LIMIT_REACHED;

/**
 * @author mesbah
 */
@Keep
public class RequestResponse {
    private int responseCode;
    @Nullable
    private Object responseBody;
    @Nullable
    private Map<String, String> headers;


    public int getResponseCode() {
        return responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    @Nullable
    public Object getResponseBody() {
        return responseBody;
    }

    public void setResponseBody(@Nullable Object body) {
        this.responseBody = body;
    }

    @NonNull
    public Map<String, String> getHeaders() {
        return headers == null ? Collections.<String, String>emptyMap() : headers;
    }

    public RequestResponse setHeaders(@Nullable Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    @NonNull
    @Override
    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public String toString() {
        return "Response code: " + responseCode + ", Response body: " + responseBody;
    }

    @Keep
    @IntDef({OK, NOT_MODIFIED, BAD_REQUEST})
    @Retention(RetentionPolicy.SOURCE)
    public @interface HttpStatusCode {

        @Keep
        @IntDef({OK})
        @Retention(RetentionPolicy.SOURCE)
        @interface _2xx {
            int OK = 200;
        }

        @Keep
        @IntDef({NOT_MODIFIED})
        @Retention(RetentionPolicy.SOURCE)
        @interface _3xx {
            int NOT_MODIFIED = 304;
        }

        @Keep
        @IntDef({BAD_REQUEST, RATE_LIMIT_REACHED})
        @Retention(RetentionPolicy.SOURCE)
        @interface _4xx {
            int BAD_REQUEST = 400;
            int RATE_LIMIT_REACHED = 429;
        }
    }
}
