package com.instabug.library.logging.listeners.networklogs

/**
 * An interface that can be implemented whenever you want to get a callback when your NetworkLogs
 * are captured in order to view or modify them.
 */
fun interface NetworkLogListener {
    /**
     * A callback method that accepts a snapshot {@link NetworkLogSnapshot} of your
     * network logs as a parameter.
     *
     * @param networkLog is a snapshot of your captured NetworkLogs that can be viewed or modified.
     *
     * @return the modified {@link NetworkLogSnapshot} or null if you want Instabug to
     * ignore the captured NetworkLog.
     */
    fun onNetworkLogCaptured(networkLog: NetworkLogSnapshot): NetworkLogSnapshot?
}