package com.instabug.library.internal.utils.memory

import com.instabug.library.Feature
import com.instabug.library.IBGFeature
import com.instabug.library.Instabug
import com.instabug.library.diagnostics.IBGDiagnostics
import com.instabug.library.diagnostics.nonfatals.model.NonFatal
import com.instabug.library.settings.SettingsManager
import org.json.JSONObject

object IBGLowMemoryHandler {

    @JvmStatic
    var isSDKPausedOnLowMemory = false

    @JvmStatic
    fun handleConfiguration(featuresResponse: JSONObject) {
        val isDisableOnLowMemory: Boolean =
            featuresResponse.optBoolean("an_disable_on_low_memory", false)
        SettingsManager.getInstance()
            .setFeatureEnabled(IBGFeature.DISABLE_ON_LOW_MEMORY, isDisableOnLowMemory)
    }

    @JvmStatic
    fun pauseSDKIfNeeded() {
        if (shouldDisableSDKOnLowMemory()) {
            IBGDiagnostics.reportNonFatal(
                IBGLowMemroyWarning("Device is running low on memory"),
                "Disabling Instabug temporaily", NonFatal.Priority.HIGH
            )
            Instabug.pauseSdk()
            isSDKPausedOnLowMemory = true
        }
    }

    private fun shouldDisableSDKOnLowMemory(): Boolean = SettingsManager.getInstance()
        .getFeatureState(IBGFeature.DISABLE_ON_LOW_MEMORY, false) == Feature.State.ENABLED
}