package com.instabug.library.internal.dataretention.core;

import androidx.annotation.NonNull;

/**
 * A functional interface that represents some boolean rules
 */
@FunctionalInterface
public interface Rule<T extends Record<?>> {

    /**
     * @param record the record on which the rule should be applied on
     * @return true if the rule applies to the record, false otherwise
     */
    boolean isSatisfiable(@NonNull T record);
}
