package com.instabug.library.experiments.cache;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;

import java.util.List;

@WorkerThread
public interface ExperimentsDBManager {

    void insertExperiments(@NonNull List<String> experiments);

    void deleteExperiments(@NonNull List<String> experiments);

    int trimToLimit(int limit);

    void clearAllExperiments();

    @Nullable
    List<String> getExperiments(float percentage);
}
