package com.instabug.library.diagnostics.sdkEvents.mappers

import android.database.Cursor
import com.instabug.library.diagnostics.diagnostics_db.SDKEventsEntry.COLUMN_COUNT
import com.instabug.library.diagnostics.diagnostics_db.SDKEventsEntry.COLUMN_KEY
import com.instabug.library.diagnostics.diagnostics_db.SDKEventsEntry.ColumnsTransitiveState.COUNT_TRANSITIVE_STATE
import com.instabug.library.diagnostics.diagnostics_db.SDKEventsEntry.ColumnsTransitiveState.KEY_TRANSITIVE_STATE
import com.instabug.library.diagnostics.sdkEvents.models.SDKEvent
import com.instabug.library.internal.storage.cache.dbv2.IBGContentValues
import com.instabug.library.safetyUse

internal class SDKEventDbMapper {

    /*
    * if the cursor is not null it extracts a list of sdk events from the cursor
    * else it returns null
    */
    fun getSDKEventList(cursor: Cursor?): List<SDKEvent>? = cursor?.safetyUse {
        val sdkEvents = mutableListOf<SDKEvent>()
        while (it.moveToNext()) extractEventFromCursor(it)?.let(sdkEvents::add)
        sdkEvents.takeIf(List<SDKEvent>::isNotEmpty)
    }

    /*
     * if the cursor is not null it extracts the sdk event from the cursor
     * else it returns null
     */
    fun getSDKEvent(cursor: Cursor?): SDKEvent? =
        cursor?.safetyUse {
            if (it.moveToFirst()) extractEventFromCursor(it)
            else null
        }

    private fun extractEventFromCursor(cursor: Cursor?): SDKEvent? = cursor?.run {
        SDKEvent(
            getString(getColumnIndexOrThrow(COLUMN_KEY)),
            getInt(getColumnIndexOrThrow(COLUMN_COUNT))
        )
    }

    /*
    * if the input event is valid it returns IBGContentValues mapping the input event
    * if not it returns null
    */
    fun toContentValues(item: SDKEvent): IBGContentValues = IBGContentValues().apply {
        put(COLUMN_KEY, item.key, KEY_TRANSITIVE_STATE)
        put(COLUMN_COUNT, item.count, COUNT_TRANSITIVE_STATE)
    }
}