package com.instabug.library.core.eventbus

import com.instabug.library.core.eventbus.instabugeventbus.InstabugEventBus
import com.instabug.library.util.threading.PoolProvider

object AppStateEventBus : InstabugEventBus<AppStateEvent?>() {

    private const val ORDERED_EXECUTOR_KEY = "AppStateEventBus"
    private var lastEventTimeStamp = 0L

    infix fun emit(event: AppStateEvent) = post(event)

    override fun <E : AppStateEvent?> post(event: E) {
        event?.takeIf(::isNotOutOfDate)
            ?.also(::updateLastEventTimeStamp)
            ?.let(::dispatch)
    }

    private fun <E : AppStateEvent?> isNotOutOfDate(event: E) =
        (event?.timeStampMillis ?: 0) > lastEventTimeStamp

    private fun <E : AppStateEvent> updateLastEventTimeStamp(event: E) {
        this.lastEventTimeStamp = event.timeStampMillis
    }

    private fun <E : AppStateEvent> dispatch(event: E) =
        PoolProvider.postOrderedIOTask(ORDERED_EXECUTOR_KEY) {
            super.post(event)
        }
}