package com.instabug.library.view.viewgroup;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

import androidx.annotation.Nullable;

import com.instabug.library.R;
import com.instabug.library.util.ScreenUtility;

public class IBPercentageRelativeLayout extends RelativeLayout implements PercentageRelativeLayoutContract.View {

    private final PercentageRelativeLayoutContract.Presenter presenter;
    private final float maxHeightRatio;

    public IBPercentageRelativeLayout(Context context) {
        this(context, null);
    }

    public IBPercentageRelativeLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public IBPercentageRelativeLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (attrs != null) {
            TypedArray a = getContext().obtainStyledAttributes(attrs, R.styleable.IBPercentageRelativeLayout);
            maxHeightRatio = a.getFloat(R.styleable.IBPercentageRelativeLayout_maxHeightRatio, 100);
            a.recycle();
        } else {
            maxHeightRatio = 100;
        }
        presenter = new PercentageRelativeLayoutPresenter(this);
    }

    @Override
    public float getMaxHeightRatio() {
        return maxHeightRatio;
    }

    @Override
    public float getScreenHeight() {
        if (ScreenUtility.hasNavBar(getContext())) {
            int navigationBarHeight = ScreenUtility.getNavigationBarHeight(getResources());
            return Resources.getSystem().getDisplayMetrics().heightPixels - navigationBarHeight;
        }
        return Resources.getSystem().getDisplayMetrics().heightPixels;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int[] measureSpec = presenter.calculateMeasureSpec(widthMeasureSpec, heightMeasureSpec);
        super.onMeasure(measureSpec[0], measureSpec[1]);
    }
}
