package com.instabug.library.util.filters;

/**
 * A Filter can be used to provide control over what is passed through {@link Filters} chain
 *
 * @param <T> the type of item is to be filtered
 */
@FunctionalInterface
public interface Filter<T> {

    /**
     * Applies a filter the passed element if it meets the filter criteria
     * and then returns the filtered result
     *
     * @param t the element in which the filter will be applied on
     * @return the filter result or same value if non was applied
     */
    T apply(T t);
}
