package com.instabug.library.util

import java.text.SimpleDateFormat
import java.util.Calendar
import java.util.Date
import java.util.Locale


object DateUtils {

    fun getTodayDateWithoutTime(): Date {
        val calendar = Calendar.getInstance()
        calendar[Calendar.HOUR_OF_DAY] = 0
        calendar[Calendar.MINUTE] = 0
        calendar[Calendar.SECOND] = 0
        calendar[Calendar.MILLISECOND] = 0

        return calendar.time
    }
}

fun Date.toFormattedString(format: String): String {
    val dateFormat: SimpleDateFormat = try {
        SimpleDateFormat(format, Locale.ENGLISH)

    } catch (e: Exception) {
        SimpleDateFormat("dd-MM-yyyy", Locale.ENGLISH)
    }

    return dateFormat.format(this)

}