package com.instabug.library.util

import android.annotation.SuppressLint
import android.app.ActivityManager
import android.content.Context
import android.content.pm.PackageManager
import android.os.Build
import androidx.annotation.RequiresApi

object AppUtils {
    @SuppressLint("NewApi")
    @JvmStatic
    fun getInstallerPackageName(context: Context?): String? = context
        ?.takeIf { it.packageManager != null }
        ?.run {
            if (DeviceStateProvider.getOSVersion() >= Build.VERSION_CODES.R) {
                getPostAndroidRInstallerPackage(packageManager, context)
            } else {
                getPreAndroidRInstallerPackage(packageManager, context)
            }
        }

    @RequiresApi(api = Build.VERSION_CODES.R)
    private fun getPostAndroidRInstallerPackage(
        packageManager: PackageManager,
        context: Context
    ): String? {
        return try {
            packageManager.getInstallSourceInfo(context.packageName).installingPackageName
        } catch (t: Throwable) {
            getPreAndroidRInstallerPackage(packageManager, context)
        }
    }

    private fun getPreAndroidRInstallerPackage(
        packageManager: PackageManager,
        context: Context
    ): String? = packageManager.getInstallerPackageName(context.applicationContext.packageName)

    @JvmStatic
    fun isAppForeground(context: Context?): Boolean {
        val activityManager = context?.getSystemService(Context.ACTIVITY_SERVICE) as? ActivityManager
        val appPackageName = context?.packageName
        return activityManager?.runningAppProcesses?.takeIf { it.isNotEmpty() }
            ?.find {
                it.importance == ActivityManager.RunningAppProcessInfo.IMPORTANCE_FOREGROUND
                        && it.processName == appPackageName
            }?.let {
                true
            } ?: false
    }
}
