package com.instabug.library.ui.custom

import android.annotation.SuppressLint
import android.content.Context
import android.content.res.TypedArray
import android.text.InputType
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.EditText
import android.widget.LinearLayout
import android.widget.TextView
import com.instabug.library.R


@SuppressLint("Recycle")
class InstabugEditText @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyle: Int = 0
) : LinearLayout(context, attrs, defStyle) {
    val labelTextView: TextView
    val editText: EditText

    init {
        context
            .layoutInflater
            .inflate(R.layout.instabug_edit_text, this, true)
            .let { view ->
                orientation = VERTICAL
                labelTextView = view.findViewById(R.id.ib_txt_label)
                editText = view.findViewById(R.id.ib_edit_text)
                context
            }.obtainStyledAttributes(attrs, R.styleable.InstabugEditText, defStyle, 0)
            .fillViewsFromAttrs()


    }

    private fun TypedArray.fillViewsFromAttrs() {
        try {
            editText.setText(text)
            labelTextView.text = label
            editText.inputType = inputType
            editText.hint = hint
            editText.isSingleLine = isSingleLine
        } finally {
            recycle()
        }
    }

    private val TypedArray.label
        get() = getText(R.styleable.InstabugEditText_ib_edit_label)

    private val TypedArray.inputType
        get() = getInt(
            R.styleable.InstabugEditText_android_inputType,
            InputType.TYPE_CLASS_TEXT
        )
    private val TypedArray.text
        get() = getText(R.styleable.InstabugEditText_android_text)
    private val TypedArray.hint
        get() = getText(R.styleable.InstabugEditText_android_hint)
    private val TypedArray.isSingleLine
        get() = getBoolean(R.styleable.InstabugEditText_android_singleLine, false)

}

private val Context.layoutInflater
    get() = getSystemService(Context.LAYOUT_INFLATER_SERVICE) as LayoutInflater