package com.instabug.library.tokenmapping

import com.instabug.library.InstabugNetworkJob
import com.instabug.library.networkv2.INetworkManager
import com.instabug.library.networkv2.NetworkManager

object TokenMappingServiceLocator {


    @JvmStatic
    fun getTokenMappingConfigsHandler(): TokenMappingConfigsHandler {
        return TokenMappingConfigsHandlerImpl()
    }

    @JvmStatic
    fun getTokenMappingConfigs(): TokenMappingConfigurations {
        return TokenMappingConfigurationsImpl
    }

    @JvmStatic
    @JvmName("getTokenMappingSync")
    fun getTokenMappingSync(): InstabugNetworkJob {
        return TokenMappingSync(getTokenMappingConfigs())
    }

    fun getNetworkManager(): INetworkManager {
        return NetworkManager()
    }

}